/*
 * Decompiled with CFR 0.152.
 */
package net.algart.model3d.common.movement;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import net.algart.model3d.common.movement.ParameterGetter;
import net.algart.model3d.common.movement.model.BunkerWall;
import net.algart.model3d.common.movement.model.Earth;
import net.algart.model3d.common.movement.model.EarthGravitationRule;
import net.algart.model3d.common.movement.model.ElasticBall;
import net.algart.model3d.common.movement.model.ElasticBallByBunkerWallInteractionRule;
import net.algart.model3d.common.movement.model.ElasticBallsInteractionRule;
import net.algart.model3d.common.movement.model.EulerMovementIntegrator;
import net.algart.model3d.common.movement.model.GridItemSet;
import net.algart.model3d.common.movement.model.InteractionRule;
import net.algart.model3d.common.movement.model.Item;
import net.algart.model3d.common.movement.model.ItemSet;
import net.algart.model3d.common.movement.model.MovementIntegrator;
import net.algart.model3d.common.movement.model.PhysicalMedium;
import net.algart.model3d.common.movement.model.PhysicalMediumResistanceRule;
import net.algart.model3d.common.movement.model.RungeKuttaMovementIntegrator;
import net.algart.model3d.common.movement.model.SimpleItemSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MovingSpheresModel {
    public static final int EULER_MOVEMENT_INTEGRATOR = 0;
    public static final int RK4_MOVEMENT_INTEGRATOR = 1;
    public static final int RKF45_MOVEMENT_INTEGRATOR = 2;
    private static final double DEFAULT_DELTA_T = 5.0E-4;
    protected MovementIntegrator movementIntegrator;
    private double bunkerMinX = 0.0;
    private double bunkerMaxX = 100.0;
    private double bunkerMinY = 0.0;
    private double bunkerMaxY = 100.0;
    private double bunkerMinZ = 0.0;
    private double bunkerMaxZ = 100.0;
    private int numberOfWalls = 0;
    private Earth earth = null;
    private PhysicalMedium physicalMedium = null;
    private double ballDensity = 1.0;
    private double ballElasticityModulus = 1.0E9;
    private double ballFrictionCoefficient = 0.0;
    private final ItemSet itemSet;
    private int movementIntegratorCode = 0;
    private Random rnd = new Random();

    public MovingSpheresModel(ParameterGetter parameterGetter) {
        double d;
        double d2;
        double d3;
        int n;
        int n2;
        Object object;
        String string = parameterGetter.getParameter("optimization-grid");
        if (string != null) {
            object = string.split("[,= ]+");
            if (((String[])object).length < 4) {
                throw new IllegalArgumentException("Illegal grid description: " + string + " (3 dimensions required and then CENTERS or WALLS)");
            }
            n2 = Integer.parseInt(object[0]);
            n = Integer.parseInt(object[1]);
            int n3 = Integer.parseInt(object[2]);
            GridItemSet.GridRangeStyle gridRangeStyle = object[3].equals("CENTERS") ? GridItemSet.GridRangeStyle.MINIMUM_AND_MAXIMUM_CENTERS : GridItemSet.GridRangeStyle.MINIMUM_AND_MAXIMUM_WALL_VERTICES;
            this.itemSet = new GridItemSet(n2, n, n3, gridRangeStyle);
        } else {
            this.itemSet = new SimpleItemSet();
        }
        string = parameterGetter.getParameter("ball-density");
        if (string != null) {
            this.ballDensity = Double.parseDouble(string);
        }
        if ((string = parameterGetter.getParameter("ball-elasticity-modulus")) != null) {
            this.ballElasticityModulus = Double.parseDouble(string);
        }
        if ((string = parameterGetter.getParameter("ball-friction-coefficient")) != null) {
            this.ballFrictionCoefficient = Double.parseDouble(string);
        }
        this.movementIntegrator = this.createMovementIntegrator(0);
        string = parameterGetter.getParameter("integration-method");
        if (string != null) {
            if (string.equalsIgnoreCase("euler")) {
                this.movementIntegratorCode = 0;
            } else if (string.equalsIgnoreCase("runge-kutta") || string.equalsIgnoreCase("rk-4")) {
                this.movementIntegratorCode = 1;
            } else if (string.equalsIgnoreCase("rkf-45")) {
                this.movementIntegratorCode = 2;
            } else {
                throw new IllegalArgumentException("Unknown integration method \"" + string + "\"");
            }
            this.setMovementIntegrator(this.movementIntegratorCode);
        }
        if ((string = parameterGetter.getParameter("delta-t")) != null) {
            this.movementIntegrator.setDeltaT(Double.parseDouble(string));
        }
        if ((string = parameterGetter.getParameter("viscous-forces")) != null) {
            this.movementIntegrator.setViscousForces(Boolean.parseBoolean(string));
        }
        if ((string = parameterGetter.getParameter("acceleration-limit")) != null) {
            this.movementIntegrator.setAccelerationLimit(Double.parseDouble(string));
        }
        if ((string = parameterGetter.getParameter("velocity-limit")) != null) {
            this.movementIntegrator.setVelocityLimit(Double.parseDouble(string));
        }
        if ((string = parameterGetter.getParameter("number-of-parallel-tasks")) != null) {
            this.movementIntegrator.setNumberOfParallelTasks(Integer.parseInt(string));
        }
        if ((string = parameterGetter.getParameter("rand-seed")) != null) {
            this.setRandSeed(Integer.parseInt(string));
        }
        object = new ArrayList();
        n2 = 1;
        while ((string = parameterGetter.getParameter("item-" + n2)) != null) {
            String[] stringArray = string.split("[,= ]+");
            if (stringArray[0].equalsIgnoreCase("elastic-ball")) {
                if (stringArray.length < 5) {
                    throw new IllegalArgumentException("Illegal item description: " + string + " (4 numbers required)");
                }
                double d4 = Double.parseDouble(stringArray[1]);
                d3 = Double.parseDouble(stringArray[2]);
                d2 = Double.parseDouble(stringArray[3]);
                d = Double.parseDouble(stringArray[4]);
                object.add(new ElasticBall(d4, d3, d2, d, this.ballDensity, this.ballElasticityModulus, this.ballFrictionCoefficient));
            } else if (stringArray[0].equalsIgnoreCase("open-area") || stringArray[0].equalsIgnoreCase("simple-bunker") || stringArray[0].equalsIgnoreCase("simple-open-bunker")) {
                if (stringArray.length < 7) {
                    throw new IllegalArgumentException("Illegal item description: " + string + " (6 numbers required: minX, maxX, minY, maxY, minZ, maxZ)");
                }
                this.bunkerMinX = Double.parseDouble(stringArray[1]);
                this.bunkerMaxX = Double.parseDouble(stringArray[2]);
                this.bunkerMinY = Double.parseDouble(stringArray[3]);
                this.bunkerMaxY = Double.parseDouble(stringArray[4]);
                this.bunkerMinZ = Double.parseDouble(stringArray[5]);
                this.bunkerMaxZ = Double.parseDouble(stringArray[6]);
                this.numberOfWalls = stringArray[0].equalsIgnoreCase("open-area") ? 0 : (stringArray[0].equalsIgnoreCase("simple-bunker") ? 6 : 5);
            } else if (stringArray[0].equalsIgnoreCase("earth")) {
                if (stringArray.length < 2) {
                    throw new IllegalArgumentException("Illegal item description: " + string + " (earth gravity required)");
                }
                this.earth = new Earth(Double.parseDouble(stringArray[1]));
            } else if (stringArray[0].equalsIgnoreCase("physical-medium")) {
                if (stringArray.length < 2) {
                    throw new IllegalArgumentException("Illegal item description: " + string + " (medium resistance coefficient required)");
                }
                this.physicalMedium = new PhysicalMedium(Double.parseDouble(stringArray[1]));
            } else {
                throw new IllegalArgumentException("Unknown item name \"" + stringArray[0] + "\"");
            }
            ++n2;
        }
        this.addInitialItems();
        this.itemSet.addAll((Collection<? extends Item>)object);
        string = parameterGetter.getParameter("add-nonintersecting-random-elastic-balls-in-bunker");
        if (string != null) {
            String[] stringArray = string.split("[,= ]+");
            if (stringArray.length < 3) {
                throw new IllegalArgumentException("Illegal elastic balls set description: " + string + " (int count, double averageRadius, double standardDeviation required, " + " then double minRadius and double maxRadius possible)");
            }
            n = Integer.parseInt(stringArray[0]);
            double d5 = Double.parseDouble(stringArray[1]);
            d3 = Double.parseDouble(stringArray[2]);
            d2 = stringArray.length >= 4 ? Double.parseDouble(stringArray[3]) : 0.0;
            d = stringArray.length >= 5 ? Double.parseDouble(stringArray[4]) : Double.POSITIVE_INFINITY;
            this.addNonintersectingRandomElasticBallsInBunker(n, d5, d3, d2, d);
        }
    }

    public void resetRandSeed() {
        this.rnd = new Random();
    }

    public void setRandSeed(long l) {
        this.rnd.setSeed(l);
    }

    public Random getRand() {
        return this.rnd;
    }

    public ItemSet getItemSet() {
        return this.itemSet;
    }

    public void removeAll() {
        this.itemSet.removeItems(0, this.itemSet.size());
    }

    public void addInitialItems() {
        if (this.earth != null) {
            this.itemSet.add(this.earth);
        }
        if (this.physicalMedium != null) {
            this.itemSet.add(this.physicalMedium);
        }
        if (this.numberOfWalls >= 5) {
            this.itemSet.add(new BunkerWall(1.0, 0.0, 0.0, this.bunkerMinX, this.bunkerMinX, this.bunkerMinY, this.bunkerMinZ, this.bunkerMinX, this.bunkerMaxY, this.bunkerMinZ, this.bunkerMinX, this.bunkerMaxY, this.bunkerMaxZ, this.bunkerMinX, this.bunkerMinY, this.bunkerMaxZ));
            this.itemSet.add(new BunkerWall(-1.0, 0.0, 0.0, -this.bunkerMaxX, this.bunkerMaxX, this.bunkerMinY, this.bunkerMinZ, this.bunkerMaxX, this.bunkerMaxY, this.bunkerMinZ, this.bunkerMaxX, this.bunkerMaxY, this.bunkerMaxZ, this.bunkerMaxX, this.bunkerMinY, this.bunkerMaxZ));
            this.itemSet.add(new BunkerWall(0.0, 1.0, 0.0, this.bunkerMinY, this.bunkerMinX, this.bunkerMinY, this.bunkerMinZ, this.bunkerMaxX, this.bunkerMinY, this.bunkerMinZ, this.bunkerMaxX, this.bunkerMinY, this.bunkerMaxZ, this.bunkerMinX, this.bunkerMinY, this.bunkerMaxZ));
            this.itemSet.add(new BunkerWall(0.0, -1.0, 0.0, -this.bunkerMaxY, this.bunkerMinX, this.bunkerMaxY, this.bunkerMinZ, this.bunkerMaxX, this.bunkerMaxY, this.bunkerMinZ, this.bunkerMaxX, this.bunkerMaxY, this.bunkerMaxZ, this.bunkerMinX, this.bunkerMaxY, this.bunkerMaxZ));
            this.itemSet.add(new BunkerWall(0.0, 0.0, 1.0, this.bunkerMinZ, this.bunkerMinX, this.bunkerMinY, this.bunkerMinZ, this.bunkerMaxX, this.bunkerMinY, this.bunkerMinZ, this.bunkerMaxX, this.bunkerMaxY, this.bunkerMinZ, this.bunkerMinX, this.bunkerMaxY, this.bunkerMinZ));
        }
        if (this.numberOfWalls >= 6) {
            this.itemSet.add(new BunkerWall(0.0, 0.0, -1.0, -this.bunkerMaxZ, this.bunkerMinX, this.bunkerMinY, this.bunkerMaxZ, this.bunkerMaxX, this.bunkerMinY, this.bunkerMaxZ, this.bunkerMaxX, this.bunkerMaxY, this.bunkerMaxZ, this.bunkerMinX, this.bunkerMaxY, this.bunkerMaxZ));
        }
    }

    public void addNonintersectingRandomElasticBallsInBunker(int n, double d, double d2, double d3, double d4) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("Average radius must be positive");
        }
        if (d3 < 0.0) {
            throw new IllegalArgumentException("Minimal radius must be positive");
        }
        if (d4 < 0.0) {
            throw new IllegalArgumentException("Maximal radius must be positive");
        }
        if (d3 > d4) {
            throw new IllegalArgumentException("Minimal radius must be <= maximal radius");
        }
        d4 = Math.min(d4, 0.5 * (this.bunkerMaxX - this.bunkerMinX));
        d4 = Math.min(d4, 0.5 * (this.bunkerMaxY - this.bunkerMinY));
        d4 = Math.min(d4, 0.5 * (this.bunkerMaxZ - this.bunkerMinZ));
        long l = (long)this.itemSet.size() + (long)n;
        while ((long)this.itemSet.size() < l) {
            int n2 = 0;
            ElasticBall elasticBall = null;
            block1: do {
                if (++n2 >= 1000) {
                    throw new IllegalArgumentException("Cannot add sphere #" + this.itemSet.size() + " in 1000 attempts");
                }
                double d5 = d + this.rnd.nextGaussian() * d2;
                if (d5 < d3 || d5 > d4) continue;
                double d6 = this.bunkerMinX + d5 + this.rnd.nextDouble() * (this.bunkerMaxX - this.bunkerMinX - 2.0 * d5);
                double d7 = this.bunkerMinY + d5 + this.rnd.nextDouble() * (this.bunkerMaxY - this.bunkerMinY - 2.0 * d5);
                double d8 = this.bunkerMinZ + d5 + this.rnd.nextDouble() * (this.bunkerMaxZ - this.bunkerMinZ - 2.0 * d5);
                elasticBall = new ElasticBall(d6, d7, d8, d5, this.ballDensity, this.ballElasticityModulus, this.ballFrictionCoefficient);
                int n3 = this.itemSet.size();
                for (int i = 0; i < n3; ++i) {
                    Item item = this.itemSet.get(i);
                    if (!(item instanceof ElasticBall) || !((ElasticBall)item).intersects(elasticBall)) continue;
                    elasticBall = null;
                    continue block1;
                }
            } while (elasticBall == null);
            this.itemSet.add(elasticBall);
        }
    }

    public double getBunkerMinX() {
        return this.bunkerMinX;
    }

    public void setBunkerMinX(double d) {
        this.bunkerMinX = d;
    }

    public double getBunkerMaxX() {
        return this.bunkerMaxX;
    }

    public void setBunkerMaxX(double d) {
        this.bunkerMaxX = d;
    }

    public double getBunkerMinY() {
        return this.bunkerMinY;
    }

    public void setBunkerMinY(double d) {
        this.bunkerMinY = d;
    }

    public double getBunkerMaxY() {
        return this.bunkerMaxY;
    }

    public void setBunkerMaxY(double d) {
        this.bunkerMaxY = d;
    }

    public double getBunkerMinZ() {
        return this.bunkerMinZ;
    }

    public void setBunkerMinZ(double d) {
        this.bunkerMinZ = d;
    }

    public double getBunkerMaxZ() {
        return this.bunkerMaxZ;
    }

    public void setBunkerMaxZ(double d) {
        this.bunkerMaxZ = d;
    }

    public int getNumberOfWalls() {
        return this.numberOfWalls;
    }

    public double getBallDensity() {
        return this.ballDensity;
    }

    public void setBallDensity(double d) {
        this.ballDensity = d;
    }

    public double getBallElasticityModulus() {
        return this.ballElasticityModulus;
    }

    public void setBallElasticityModulus(double d) {
        this.ballElasticityModulus = d;
    }

    public double getBallFrictionCoefficient() {
        return this.ballFrictionCoefficient;
    }

    public void setBallFrictionCoefficient(double d) {
        this.ballFrictionCoefficient = d;
    }

    public Earth getEarth() {
        return this.earth;
    }

    public PhysicalMedium getPhysicalMedium() {
        return this.physicalMedium;
    }

    protected List<InteractionRule> createInteractionRules() {
        return Arrays.asList(new EarthGravitationRule(), new PhysicalMediumResistanceRule(), new ElasticBallsInteractionRule(), new ElasticBallByBunkerWallInteractionRule());
    }

    protected MovementIntegrator createMovementIntegrator(int n) {
        List<InteractionRule> list = this.createInteractionRules();
        switch (n) {
            case 0: {
                return EulerMovementIntegrator.getEulerIntegrator(this.itemSet, list, 5.0E-4);
            }
            case 1: {
                return RungeKuttaMovementIntegrator.getRungeKutta4Integrator(this.itemSet, list, 5.0E-4);
            }
            case 2: {
                return RungeKuttaMovementIntegrator.getRungeKuttaFehlberg45Integrator(this.itemSet, list, 5.0E-4);
            }
        }
        throw new IllegalArgumentException("Unallowed movementIntegratorCode = " + n);
    }

    public int getMovementIntegratorCode() {
        return this.movementIntegratorCode;
    }

    public void setMovementIntegrator(int n) {
        MovementIntegrator movementIntegrator = this.createMovementIntegrator(n);
        movementIntegrator.copyBasicSettings(this.movementIntegrator);
        this.movementIntegrator = movementIntegrator;
        this.movementIntegratorCode = n;
    }
}

