/*
 * Decompiled with CFR 0.152.
 */
package net.algart.model3d.common.movement;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import net.algart.drawing3d.ColoringRule;
import net.algart.drawing3d.ConvexPlanePolygon3DDrawingRule;
import net.algart.drawing3d.CoordinateSystem3D;
import net.algart.drawing3d.Drawer3D;
import net.algart.drawing3d.SimpleColoringRule;
import net.algart.drawing3d.SimpleDrawer3D;
import net.algart.drawing3d.Sphere3DDrawingRule;
import net.algart.model3d.common.movement.MovingSpheresModel;
import net.algart.model3d.common.movement.ParameterGetter;
import net.algart.model3d.common.movement.model.BunkerWall;
import net.algart.model3d.common.movement.model.Earth;
import net.algart.model3d.common.movement.model.HavingMass;
import net.algart.model3d.common.movement.model.HavingVelocity;
import net.algart.model3d.common.movement.model.Item;
import net.algart.model3d.common.movement.model.ItemSet;
import net.algart.model3d.common.movement.model.Spherical;
import net.algart.model3d.common.movement.view.BunkerWallShapingRule;
import net.algart.model3d.common.movement.view.SphereShapingRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MovingSpheresView {
    private int antialiasingScale = 1;
    private double drawingGamma = 1.0;
    private Color backgroundColor = Color.white;
    private final SimpleColoringRule bunkerWallColoringRule = new SimpleColoringRule(BunkerWall.class, Color.gray);
    private final SimpleColoringRule itemColoringRule = new SimpleColoringRule(Object.class, Color.gray);
    private CoordinateSystem3D coordinateSystem = new CoordinateSystem3D();
    private double zCut = 1.0;
    private boolean showStatistics = false;
    protected volatile BufferedImage modelImage = null;

    public MovingSpheresView(ParameterGetter parameterGetter, int n, int n2) {
        String string = parameterGetter.getParameter("background-color");
        if (string != null) {
            this.backgroundColor = Color.decode(string);
        }
        if ((string = parameterGetter.getParameter("item-color")) != null) {
            this.itemColoringRule.setColor(MovingSpheresView.decodeColorWithAlpha(string));
        }
        if ((string = parameterGetter.getParameter("bunker-wall-color")) != null) {
            this.bunkerWallColoringRule.setColor(MovingSpheresView.decodeColorWithAlpha(string));
        }
        if ((string = parameterGetter.getParameter("antialiasing-scale")) != null) {
            this.antialiasingScale = Integer.parseInt(string);
        }
        if ((string = parameterGetter.getParameter("drawing-gamma")) != null) {
            this.drawingGamma = Double.parseDouble(string);
        }
        if ((string = parameterGetter.getParameter("show-statistics")) != null) {
            this.showStatistics = Boolean.parseBoolean(string);
        }
        this.coordinateSystem.setOrigin(0.5 * (double)n * (double)this.antialiasingScale, 0.5 * (double)n2 * (double)this.antialiasingScale, 0.0);
        this.coordinateSystem.setScale(this.antialiasingScale);
    }

    public BufferedImage getModelImage() {
        return this.modelImage;
    }

    public int getAntialiasingScale() {
        return this.antialiasingScale;
    }

    public void setAntialiasingScale(int n) {
        this.antialiasingScale = n;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color color) {
        this.backgroundColor = color;
    }

    public SimpleColoringRule getBunkerWallColoringRule() {
        return this.bunkerWallColoringRule;
    }

    public SimpleColoringRule getItemColoringRule() {
        return this.itemColoringRule;
    }

    public CoordinateSystem3D getCoordinateSystem() {
        return this.coordinateSystem;
    }

    public double getZCut() {
        return this.zCut;
    }

    public void setZCut(double d) {
        this.zCut = d;
    }

    public boolean isShowStatistics() {
        return this.showStatistics;
    }

    public void setShowStatistics(boolean bl) {
        this.showStatistics = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildModelImage(Object object, MovingSpheresModel movingSpheresModel, int n, int n2) {
        Object object2;
        SimpleDrawer3D simpleDrawer3D;
        List<Item> list;
        ItemSet itemSet = movingSpheresModel.getItemSet();
        Sphere3DDrawingRule sphere3DDrawingRule = new Sphere3DDrawingRule();
        ConvexPlanePolygon3DDrawingRule convexPlanePolygon3DDrawingRule = new ConvexPlanePolygon3DDrawingRule();
        SphereShapingRule sphereShapingRule = new SphereShapingRule();
        BunkerWallShapingRule bunkerWallShapingRule = new BunkerWallShapingRule();
        Object object3 = object;
        synchronized (object3) {
            list = itemSet.getAll();
            simpleDrawer3D = SimpleDrawer3D.getSimpleDrawer3D(n, n2, this.antialiasingScale, this.backgroundColor, Arrays.asList(sphereShapingRule, bunkerWallShapingRule), this.createColoringRules(), Arrays.asList(sphere3DDrawingRule, convexPlanePolygon3DDrawingRule));
            simpleDrawer3D.setBackgroundColor(this.backgroundColor);
            simpleDrawer3D.setCoordinateSystem(this.coordinateSystem);
            simpleDrawer3D.setGamma(this.drawingGamma);
            object2 = new double[6];
            if (simpleDrawer3D.estimateContainingParallelepiped((double[])object2, list)) {
                simpleDrawer3D.setZCut(object2[4] + (-0.001 + this.zCut * 1.002) * (object2[5] - object2[4]));
            }
        }
        simpleDrawer3D.setDrawingRules(sphere3DDrawingRule);
        simpleDrawer3D.draw(list);
        simpleDrawer3D.setDrawingRules(convexPlanePolygon3DDrawingRule);
        simpleDrawer3D.draw(list);
        object3 = ((Drawer3D)simpleDrawer3D).getImage();
        if (this.showStatistics) {
            object2 = ((BufferedImage)object3).createGraphics();
            ((Graphics)object2).setFont(new Font("SansSerif", 0, 12));
            this.drawStatusInfo((Graphics2D)object2, 5, 5, 400, movingSpheresModel);
        }
        Object object4 = object;
        object2 = object4;
        synchronized (object4) {
            this.modelImage = object3;
            // ** MonitorExit[var13_13] (shouldn't be in output)
            return;
        }
    }

    public void drawStatusInfo(Graphics2D graphics2D, int n, int n2, int n3, MovingSpheresModel movingSpheresModel) {
        Object object;
        int n4 = movingSpheresModel.getItemSet().size();
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        double d = Double.POSITIVE_INFINITY;
        double d2 = Double.NEGATIVE_INFINITY;
        List<BunkerWall> list = movingSpheresModel.getItemSet().getAll(BunkerWall.class);
        double d3 = 0.0;
        double d4 = 0.0;
        int n8 = 0;
        Earth earth = movingSpheresModel.getEarth();
        for (int i = 0; i < n4; ++i) {
            Item item = movingSpheresModel.getItemSet().get(i);
            if (item instanceof Spherical) {
                object = (Spherical)item;
                if (object.isNaN() || object.isInfinite()) continue;
                ++n5;
                double d5 = object.getRadius();
                d = Math.min(d, d5);
                d2 = Math.max(d2, d5);
                for (BunkerWall bunkerWall : list) {
                    if (!bunkerWall.isPartiallyOutside((Spherical)object)) continue;
                    ++n6;
                    break;
                }
                for (BunkerWall bunkerWall : list) {
                    if (!bunkerWall.isFullyOutside((Spherical)object)) continue;
                    ++n7;
                    break;
                }
            }
            if (!(item instanceof HavingMass) || !(item instanceof HavingVelocity)) continue;
            double d6 = ((HavingMass)item).getMass();
            double d7 = ((HavingVelocity)item).getVelocityX();
            double d8 = ((HavingVelocity)item).getVelocityY();
            double d9 = ((HavingVelocity)item).getVelocityZ();
            d3 += 0.5 * d6 * (d7 * d7 + d8 * d8 + d9 * d9);
            if (earth != null) {
                d4 += d6 * earth.getGravity() * ((HavingVelocity)item).getCenterZ();
            }
            ++n8;
        }
        double d10 = d3 + d4;
        object = new ArrayList<String>(Arrays.asList(String.format(Locale.US, "%s: t = %.5f, \u0394t = %.5f", movingSpheresModel.movementIntegrator, movingSpheresModel.movementIntegrator.getT(), movingSpheresModel.movementIntegrator.getDeltaT()), String.format(Locale.US, "%d items, %d valid balls (radii min = %.3f, max = %.3f)", n4, n5, d, d2), n6 + " / " + n7 + " partially / fully outside", String.format(Locale.US, "Kinetic energy: %.5e = %d * %.3e", d3, n8, d3 / (double)n8), String.format(Locale.US, "Potential energy: %.5e = %d * %.3e", d4, n8, d4 / (double)n8), String.format(Locale.US, "Summary energy: %.5e = %d * %.3e", d10, n8, d10 / (double)n8)));
        if (movingSpheresModel.movementIntegrator.isErrorInformationAvailable()) {
            object.addAll(Arrays.asList(String.format(Locale.US, "max \u0394 = %.5f, mean \u0394 = %.5f", movingSpheresModel.movementIntegrator.maxLastCoordinateError(), movingSpheresModel.movementIntegrator.meanLastCoordinateError()), String.format(Locale.US, "max \u0394v = %.5f, mean \u0394v = %.5f", movingSpheresModel.movementIntegrator.maxLastVelocityError(), movingSpheresModel.movementIntegrator.meanLastVelocityError())));
        }
        int n9 = graphics2D.getFontMetrics().getHeight() * object.size() + graphics2D.getFontMetrics().getDescent() + 2;
        graphics2D.setColor(Color.WHITE);
        graphics2D.fillRect(n, n2, n3, n9);
        graphics2D.setColor(Color.BLACK);
        graphics2D.drawRect(n, n2, n3, n9);
        int n10 = object.size();
        for (int i = 0; i < n10; ++i) {
            graphics2D.drawString((String)object.get(i), n + 5, n2 + (i + 1) * graphics2D.getFontMetrics().getHeight());
        }
    }

    public String movementStatusLine(MovingSpheresModel movingSpheresModel, long l, long l2) {
        long l3 = movingSpheresModel.movementIntegrator.getCounterOfCheckedNeighbours();
        long l4 = movingSpheresModel.movementIntegrator.getCounterOfProcessedInteractions();
        long l5 = movingSpheresModel.movementIntegrator.getCounterOfProcessedSymmetricInteractions();
        long l6 = movingSpheresModel.movementIntegrator.getCounterOfProcessedItems();
        int n = movingSpheresModel.movementIntegrator.getNumberOfParallelTasks();
        return String.format(Locale.US, "Time: %.3f | %d items, %.1f / %.2f / %.2f checked / actual / mutual neighbours, mean iteration time %.3f ms (%d thread" + (n == 1 ? "" : "s") + ")", movingSpheresModel.movementIntegrator.getT(), movingSpheresModel.getItemSet().size(), (double)l3 / (double)l6, (double)l4 / (double)l6, (double)l5 / (double)l6, (double)l / (double)l2 * 1.0E-6, n);
    }

    public void printAllItemsDump(MovingSpheresModel movingSpheresModel, PrintStream printStream) {
        List<Item> list = movingSpheresModel.getItemSet().getAll();
        int n = list.size();
        printStream.println("****************");
        printStream.println(n + " items at t=" + movingSpheresModel.movementIntegrator.getT());
        for (int i = 0; i < n; ++i) {
            printStream.println("Item #" + i + ": " + list.get(i));
        }
        printStream.println();
    }

    protected List<ColoringRule> createColoringRules() {
        return Arrays.asList(this.bunkerWallColoringRule, this.itemColoringRule);
    }

    public static Color decodeColorWithAlpha(String string) {
        if (string.length() < 9) {
            return Color.decode(string);
        }
        int n = Long.decode(string).intValue();
        return new Color(n, true);
    }
}

