/*
 * Decompiled with CFR 0.152.
 */
package net.algart.model3d.common.movement.model;

import net.algart.model3d.common.movement.model.HavingCenter;
import net.algart.model3d.common.movement.model.Item;
import net.algart.model3d.common.movement.model.Spherical;

public final class BunkerWall
implements Item {
    private final double a;
    private final double b;
    private final double c;
    private final double d;
    private final int verticesCount;
    private final double[] verticesXYZ;

    public BunkerWall(double d, double d2, double d3, double d4, double ... dArray) {
        if (dArray.length % 3 != 0) {
            throw new IllegalArgumentException("verticesXYZ must contain 3*N elements: verticesXYZ[3*k] is X, verticesXYZ[3*k+1] is Y, verticesXYZ[3*k+2] is Z");
        }
        double d5 = Math.sqrt(d * d + d2 * d2 + d3 * d3);
        if (d5 == 0.0) {
            throw new IllegalArgumentException("The norm of (a,b,c) vector is zero");
        }
        this.a = d / d5;
        this.b = d2 / d5;
        this.c = d3 / d5;
        this.d = d4 / d5;
        this.verticesXYZ = (double[])dArray.clone();
        this.verticesCount = dArray.length / 3;
    }

    public double getA() {
        return this.a;
    }

    public double getB() {
        return this.b;
    }

    public double getC() {
        return this.c;
    }

    public double getD() {
        return this.d;
    }

    public int getVerticesCount() {
        return this.verticesCount;
    }

    public double[] getVerticesXYZ() {
        return (double[])this.verticesXYZ.clone();
    }

    public boolean isCenterOutside(HavingCenter havingCenter) {
        return this.a * havingCenter.getCenterX() + this.b * havingCenter.getCenterY() + this.c * havingCenter.getCenterZ() - this.d < 0.0;
    }

    public boolean isPartiallyOutside(Spherical spherical) {
        return this.a * spherical.getCenterX() + this.b * spherical.getCenterY() + this.c * spherical.getCenterZ() - this.d < spherical.getRadius();
    }

    public boolean isFullyOutside(Spherical spherical) {
        return this.a * spherical.getCenterX() + this.b * spherical.getCenterY() + this.c * spherical.getCenterZ() - this.d <= -spherical.getRadius();
    }

    public String toString() {
        return "wall: " + this.a + "*x + " + this.b + "*y + " + this.c + "*z >= " + this.d;
    }
}

