/*
 * Decompiled with CFR 0.152.
 */
package net.algart.model3d.common.movement.model;

import java.util.Arrays;
import net.algart.model3d.common.movement.model.BunkerWall;
import net.algart.model3d.common.movement.model.Item;
import net.algart.model3d.common.movement.model.ItemListBuilder;
import net.algart.model3d.common.movement.model.SimpleItemSet;

public class GridItemSet
extends SimpleItemSet {
    private static final boolean DEBUG_MODE = false;
    private final GridRangeStyle gridRangeStyle;
    private final int dimX;
    private final int dimY;
    private final int dimZ;
    private int[] indexes = new int[0];
    private final int[] startIndexesInGrid;
    private double maxInteractionRadius;
    private double minCenterX;
    private double minCenterY;
    private double minCenterZ;
    private double maxCenterX;
    private double maxCenterY;
    private double maxCenterZ;
    private double stepXInv;
    private double stepYInv;
    private double stepZInv;

    public GridItemSet(ItemListBuilder itemListBuilder, int n, int n2, int n3, GridRangeStyle gridRangeStyle) {
        super(itemListBuilder);
        if (gridRangeStyle == null) {
            throw new NullPointerException("Null gridRangeStyle");
        }
        if (n <= 0 || n2 <= 0 || n3 <= 0) {
            throw new IllegalArgumentException("Zero or negative grid dimensions: " + n + " * " + n2 + " * " + n3);
        }
        if ((long)n * (long)n2 > (long)(Integer.MAX_VALUE / n3)) {
            throw new IllegalArgumentException("Too large grid: " + n + " * " + n2 + " * " + n3 + " > Integer.MAX_VALUE");
        }
        this.dimX = n;
        this.dimY = n2;
        this.dimZ = n3;
        this.startIndexesInGrid = new int[n * n2 * n3];
        this.gridRangeStyle = gridRangeStyle;
    }

    public GridItemSet(int n, int n2, int n3, GridRangeStyle gridRangeStyle) {
        this(ItemListBuilder.DEFAULT, n, n2, n3, gridRangeStyle);
    }

    public int getPossibleInteractingIndexes(int[] nArray, int n) {
        double d;
        double d2;
        int n2;
        int n3;
        if (nArray == null) {
            throw new NullPointerException("Null result argument");
        }
        int n4 = this.items.size();
        double d3 = this.maxR[n];
        if (d3 == Double.POSITIVE_INFINITY) {
            if (n4 > nArray.length) {
                throw new IllegalStateException("Not enough memory in result argument (" + nArray.length + ")");
            }
            for (int i = 0; i < n4; ++i) {
                nArray[i] = i;
            }
            return n4;
        }
        double d4 = this.x[n];
        double d5 = this.y[n];
        double d6 = this.z[n];
        double d7 = d4 - this.minCenterX;
        double d8 = d5 - this.minCenterY;
        double d9 = d6 - this.minCenterZ;
        double d10 = d3 + this.maxInteractionRadius;
        int n5 = Math.max((int)Math.floor((d7 - d10) * this.stepXInv - 1.0E-5), 0);
        int n6 = Math.max((int)Math.floor((d8 - d10) * this.stepYInv - 1.0E-5), 0);
        int n7 = Math.max((int)Math.floor((d9 - d10) * this.stepZInv - 1.0E-5), 0);
        int n8 = Math.min((int)Math.floor((d7 + d10) * this.stepXInv + 1.0E-5), this.dimX - 1);
        int n9 = Math.min((int)Math.floor((d8 + d10) * this.stepYInv + 1.0E-5), this.dimY - 1);
        int n10 = Math.min((int)Math.floor((d9 + d10) * this.stepZInv + 1.0E-5), this.dimZ - 1);
        int n11 = 0;
        int n12 = 0;
        for (n3 = n7; n3 <= n10; ++n3) {
            for (n2 = n6; n2 <= n9; ++n2) {
                int n13 = (n3 * this.dimY + n2) * this.dimX + n5;
                int n14 = n5;
                while (n14 <= n8) {
                    int n15;
                    int n16 = this.startIndexesInGrid[n13];
                    int n17 = n15 = n13 == 0 ? 0 : this.startIndexesInGrid[n13 - 1];
                    while (n17 < n16) {
                        int n18 = this.indexes[n17];
                        d2 = this.maxR[n18];
                        assert (d2 != Double.POSITIVE_INFINITY);
                        d = d3 + d2;
                        double d11 = (double)this.x[n18] - d4;
                        double d12 = (double)this.y[n18] - d5;
                        double d13 = (double)this.z[n18] - d6;
                        if (d * d >= d11 * d11 + d12 * d12 + d13 * d13) {
                            if (n11 >= nArray.length) {
                                throw new IllegalStateException("Not enough memory in result argument (" + nArray.length + ")");
                            }
                            nArray[n11++] = n18;
                        }
                        ++n17;
                        ++n12;
                    }
                    ++n14;
                    ++n13;
                }
            }
        }
        n3 = this.startIndexesInGrid[this.startIndexesInGrid.length - 1];
        while (n3 < n4) {
            double d14;
            double d15;
            double d16;
            double d17;
            n2 = this.indexes[n3];
            double d18 = this.maxR[n2];
            double d19 = d3 + d18;
            if (d19 == Double.POSITIVE_INFINITY || d19 * d19 >= d17 * (d16 = (double)this.x[n2] - d4) + d15 * (d2 = (double)this.y[n2] - d5) + d14 * (d = (double)this.z[n2] - d6)) {
                if (n11 >= nArray.length) {
                    throw new IllegalStateException("Not enough memory in result argument (" + nArray.length + ")");
                }
                nArray[n11++] = n2;
            }
            ++n3;
            ++n12;
        }
        if (n11 < nArray.length) {
            nArray[n11] = n12;
        }
        return n11;
    }

    public void preprocess() {
        int n;
        int n2;
        int n3;
        super.preprocess();
        int n4 = this.size();
        if (n4 != this.indexes.length) {
            this.indexes = new int[n4];
        }
        Arrays.fill(this.startIndexesInGrid, 0);
        this.maxInteractionRadius = Double.NEGATIVE_INFINITY;
        for (n3 = 0; n3 < n4; ++n3) {
            double d = this.maxR[n3];
            if (d == Double.POSITIVE_INFINITY || !(d > this.maxInteractionRadius)) continue;
            this.maxInteractionRadius = d;
        }
        this.gridRangeStyle.calculateMinMax(this);
        this.stepXInv = (double)this.dimX / (this.maxCenterX - this.minCenterX);
        this.stepYInv = (double)this.dimY / (this.maxCenterY - this.minCenterY);
        this.stepZInv = (double)this.dimZ / (this.maxCenterZ - this.minCenterZ);
        n3 = 0;
        for (n2 = 0; n2 < n4; ++n2) {
            int n5;
            int n6;
            if (this.maxR[n2] == Float.POSITIVE_INFINITY) continue;
            double d = this.x[n2];
            double d2 = this.y[n2];
            double d3 = this.z[n2];
            int n7 = (int)Math.floor((d - this.minCenterX) * this.stepXInv);
            int n8 = this.gridIndex(n7, n6 = (int)Math.floor((d2 - this.minCenterY) * this.stepYInv), n5 = (int)Math.floor((d3 - this.minCenterZ) * this.stepZInv));
            if (n8 < 0) continue;
            int n9 = n8;
            this.startIndexesInGrid[n9] = this.startIndexesInGrid[n9] + 1;
            ++n3;
        }
        int n10 = 0;
        for (n2 = 0; n2 < this.startIndexesInGrid.length; ++n2) {
            n = n10 + this.startIndexesInGrid[n2];
            this.startIndexesInGrid[n2] = n10;
            n10 = n;
        }
        n2 = n3;
        for (n10 = 0; n10 < n4; ++n10) {
            int n11;
            int n12;
            int n13;
            if (this.maxR[n10] != Float.POSITIVE_INFINITY && (n13 = this.gridIndex(n = (int)Math.floor(((double)this.x[n10] - this.minCenterX) * this.stepXInv), n12 = (int)Math.floor(((double)this.y[n10] - this.minCenterY) * this.stepYInv), n11 = (int)Math.floor(((double)this.z[n10] - this.minCenterZ) * this.stepZInv))) >= 0) {
                int n14 = n13;
                int n15 = this.startIndexesInGrid[n14];
                this.startIndexesInGrid[n14] = n15 + 1;
                this.indexes[n15] = n10;
                continue;
            }
            this.indexes[n2++] = n10;
        }
        assert (n2 == n4);
        if (this.startIndexesInGrid[this.startIndexesInGrid.length - 1] != n3) {
            throw new AssertionError((Object)"Internal error while building grid");
        }
    }

    private int gridIndex(int n, int n2, int n3) {
        if (n < 0 || n >= this.dimX || n2 < 0 || n2 >= this.dimY || n3 < 0 || n3 >= this.dimZ) {
            return -1;
        }
        return (n3 * this.dimY + n2) * this.dimX + n;
    }

    public String toString() {
        return "set of " + this.size() + " items on grid " + this.dimX + "x" + this.dimY + "x" + this.dimZ + " (" + this.minCenterX + ".." + this.maxCenterX + " x " + this.minCenterY + ".." + this.maxCenterY + " x " + this.minCenterZ + ".." + this.maxCenterZ + ")";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum GridRangeStyle {
        MINIMUM_AND_MAXIMUM_CENTERS{

            void calculateMinMax(GridItemSet gridItemSet) {
                gridItemSet.minCenterX = Double.POSITIVE_INFINITY;
                gridItemSet.minCenterY = Double.POSITIVE_INFINITY;
                gridItemSet.minCenterZ = Double.POSITIVE_INFINITY;
                gridItemSet.maxCenterX = Double.NEGATIVE_INFINITY;
                gridItemSet.maxCenterY = Double.NEGATIVE_INFINITY;
                gridItemSet.maxCenterZ = Double.NEGATIVE_INFINITY;
                int n = gridItemSet.size();
                for (int i = 0; i < n; ++i) {
                    if (gridItemSet.maxR[i] == Float.POSITIVE_INFINITY) continue;
                    double d = gridItemSet.x[i];
                    double d2 = gridItemSet.y[i];
                    double d3 = gridItemSet.z[i];
                    if (d < gridItemSet.minCenterX) {
                        gridItemSet.minCenterX = d;
                    }
                    if (d2 < gridItemSet.minCenterY) {
                        gridItemSet.minCenterY = d2;
                    }
                    if (d3 < gridItemSet.minCenterZ) {
                        gridItemSet.minCenterZ = d3;
                    }
                    if (d > gridItemSet.maxCenterX) {
                        gridItemSet.maxCenterX = d;
                    }
                    if (d2 > gridItemSet.maxCenterY) {
                        gridItemSet.maxCenterY = d2;
                    }
                    if (!(d3 > gridItemSet.maxCenterZ)) continue;
                    gridItemSet.maxCenterZ = d3;
                }
            }
        }
        ,
        MINIMUM_AND_MAXIMUM_WALL_VERTICES{

            void calculateMinMax(GridItemSet gridItemSet) {
                gridItemSet.minCenterX = Double.POSITIVE_INFINITY;
                gridItemSet.minCenterY = Double.POSITIVE_INFINITY;
                gridItemSet.minCenterZ = Double.POSITIVE_INFINITY;
                gridItemSet.maxCenterX = Double.NEGATIVE_INFINITY;
                gridItemSet.maxCenterY = Double.NEGATIVE_INFINITY;
                gridItemSet.maxCenterZ = Double.NEGATIVE_INFINITY;
                int n = gridItemSet.size();
                for (int i = 0; i < n; ++i) {
                    Item item = (Item)gridItemSet.items.get(i);
                    if (!(item instanceof BunkerWall)) continue;
                    double[] dArray = ((BunkerWall)item).getVerticesXYZ();
                    for (int j = 0; j < dArray.length; j += 3) {
                        double d = dArray[j];
                        double d2 = dArray[j + 1];
                        double d3 = dArray[j + 2];
                        if (d < gridItemSet.minCenterX) {
                            gridItemSet.minCenterX = d;
                        }
                        if (d2 < gridItemSet.minCenterY) {
                            gridItemSet.minCenterY = d2;
                        }
                        if (d3 < gridItemSet.minCenterZ) {
                            gridItemSet.minCenterZ = d3;
                        }
                        if (d > gridItemSet.maxCenterX) {
                            gridItemSet.maxCenterX = d;
                        }
                        if (d2 > gridItemSet.maxCenterY) {
                            gridItemSet.maxCenterY = d2;
                        }
                        if (!(d3 > gridItemSet.maxCenterZ)) continue;
                        gridItemSet.maxCenterZ = d3;
                    }
                }
            }
        };


        abstract void calculateMinMax(GridItemSet var1);
    }
}

